import UIKit

class DrawingView: UIView {
    
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func draw(_ rect: CGRect) {
        if let context = UIGraphicsGetCurrentContext()
        {
            context.setFillColor(UIColor.red.cgColor)
            context.fill(CGRect(x: 20,
                                y: 40,
                                width: self.frame.size.width - 40,
                                height: 200))
            
            context.setFillColor(UIColor.blue.cgColor)
            context.fillEllipse(in: CGRect(x: 20,
                                           y: 260,
                                           width: self.frame.size.width - 40,
                                           height: 200))

            context.setLineWidth(10.0)
            context.setStrokeColor(UIColor.green.cgColor)
            let pointsArr = [CGPoint(x: 20,
                                     y: 480),
                             CGPoint(x: self.frame.size.width - 40,
                                     y: 480)]
            
            context.addLines(between: pointsArr)
            context.strokeLineSegments(between: pointsArr)
            
        }
    }
}


class ViewController: UIViewController
{
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        let theView = DrawingView (frame: self.view.frame)
        theView.backgroundColor = UIColor.lightGray
        self.view.addSubview(theView)
        theView.setNeedsDisplay()
    }


}

